/*
 * @brief SCTimer/PWM (SCT) Blinky Match example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"


/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/


void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                  																			// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_32BIT_COUNTER); 																// unified timer

	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, (SystemCoreClock/10) - 1);						//match 0 @ 10 Hz = 100 msec

	Chip_SCT_EventStateMask(LPC_SCT, 0, ENABLE_STATE0);			    												// Event0 happens only in State0
	Chip_SCT_EventControl(LPC_SCT, 0, (CHIP_SCT_EVENTCTRL_T) 	(SCT_EVECTRL_MATCH0		|		// related to match 0
																													SCT_COMBMODE_MATCH			|		// COMBMODE[13:12] = match condition only
																															SCT_STATELD_1				|		// STATELD[14] = STATEV is loaded into state
																																		SCT_STATEEV_1));	// STATEV[15] = 1 (new state is 1)

	Chip_SCT_EventStateMask(LPC_SCT, 1, ENABLE_STATE1);			    												// Event1 happens only in State1

	Chip_SCT_EventControl(LPC_SCT, 1, (CHIP_SCT_EVENTCTRL_T) 	(SCT_EVECTRL_MATCH0		|		// related to match 0
																														SCT_COMBMODE_MATCH		|		// COMBMODE[13:12] = match condition only
																																SCT_STATELD_1			|		// STATELD[14] = STATEV is loaded into state
																																		SCT_STATEEV_0));	// STATEV[15] = 0 (new state is 0)


	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_4, SCT_EVT_0);																// event 0 will set SCT_OUT_4
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_4, SCT_EVT_1);					    								// event 1 will clear SCT_OUT_4

		LPC_SCT->LIMIT_L           = 0x0003;                  						    						// events 0 and 1 are used as counter limit

		Chip_SCT_ClearControl(LPC_SCT, SCT_CTRL_HALT_L);							        						// start timer
}


int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();


	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 10, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT4 = P1.10  (green   LED)


	SCT_Init();																			// Initialize SCT

	while (1)                                       // loop forever
	{
		__WFI();
	}
}

